//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
//
using System;
using System.Threading;

namespace ProfilingSamples
{
	public class GCPinnedMain 
	{
		private ManualResetEvent asyncEvent;
		unsafe void PinnedThread()
		{
			byte [] ba1 = new byte[100];
			byte [] ba2 = new byte[100];
			byte [] ba3 = new byte[100];
			byte [] ba4 = new byte[100];
			for(int i = 0; i < ba1.Length; i++)
			{
				ba1[i] = (byte)(i % 256);
				ba2[i] = (byte)(i % 256);
				ba3[i] = (byte)(i % 256);
				ba4[i] = (byte)(i % 256);
			}
			fixed(byte *p1 = ba1,p2 = ba2, p3 = ba3, p4 = ba4)
			{
				asyncEvent.WaitOne();
			}
		}
		void TestThread()
		{
			Thread t;
			asyncEvent = new ManualResetEvent(false);
			try
			{
				while(true)
				{
					asyncEvent.Reset();
					t = new Thread(new ThreadStart(PinnedThread));
					t.Start();

					Thread.Sleep(500);

					// Wykonanie GC zmienia generacj obiektu
					GC.Collect();

					asyncEvent.Set();
					t.Join();

					Thread.Sleep(500);
					// Wykonanie GC zmienia generacj obiektu
					GC.Collect();

					Thread.Sleep(500);
				}
			}
			catch(Exception e)
			{
				Console.WriteLine("TestThread przerywa prac: {0}", e.Message);
			}
		}
		static void Main(string [] args)
		{
			GCPinnedMain m = new GCPinnedMain();
			Thread testThread = new Thread(new ThreadStart(m.TestThread));
			testThread.Start();
			string input = Console.ReadLine();
			testThread.Abort();
			testThread.Join();
		}
	}
}